function [] = PlotGroundStructureN(NODE,BARS,N,Cutoff,Ng)
narginchk(4,5)

if (nargin==4), Ng = 32; end
figure('Name','GRAND v1.1 -- Zegard T, Paulino GH : Member force',...
    'NumberTitle','off','Color','w')
hold('on'), axis('equal','off')

N = N / max(abs(N)); % Normalize to [-1,1] force
ind = find(abs(N)>Cutoff);
MyGroupT = ceil( Ng*N(ind)); % Round up to the closest group of bars
MyGroupC = ceil(-Ng*N(ind));
GroupsT = cell(Ng,1);       % Store the indices of similar bars
GroupsC = cell(Ng,1);
for i=1:Ng
    GroupsT{i} = ind(find(MyGroupT==i));
    GroupsC{i} = ind(find(MyGroupC==i));
end
for i=1:Ng % Plot each group of similar bars in a single plot call
    if ~isempty(GroupsT{i})
        XY = [NODE(BARS(GroupsT{i},1),:) NODE(BARS(GroupsT{i},2),:)];
        GroupForce =  mean(N(GroupsT{i})); % Mean area for this group
        Color = GroupForce*[0 0 1] + (1-GroupForce)*0.75*[1 1 1];
        plot(XY(:,[1 3])',XY(:,[2 4])','LineWidth',5*sqrt(GroupForce),'Color',Color)
    end
    if ~isempty(GroupsC{i})
        XY = [NODE(BARS(GroupsC{i},1),:) NODE(BARS(GroupsC{i},2),:)];
        GroupForce = -mean(N(GroupsC{i})); % Mean area for this group
        Color = GroupForce*[1 0 0] + (1-GroupForce)*0.75*[1 1 1];
        plot(XY(:,[1 3])',XY(:,[2 4])','LineWidth',5*sqrt(GroupForce),'Color',Color)
    end
end
fprintf('-PLOT- Cutoff %g, Groups %g, Bars plotted %g\n',Cutoff,2*Ng,length(ind))
return