function [] = PlotPolyMesh(NODE,ELEM,SUPP,LOAD)
narginchk(2,4)
figure('Color','w'), hold('on'), axis('equal','off')
MaxNVer = max(cellfun(@numel,ELEM));         % Max vertices/element in mesh
PadWNaN = @(E) [E NaN(1,MaxNVer-numel(E))];  % Pad cells with NaN
ElemMat = cellfun(PadWNaN,ELEM,'UniformOutput',false);
ElemMat = vertcat(ElemMat{:});               % Create padded element matrix
patch('Faces',ElemMat,'Vertices',NODE,'FaceColor',0.9*[1 1 1]);
if (nargin>=3 && ~isempty(SUPP))
    fixed = ~isnan(SUPP(:,2:3));
    ind = find(all([fixed(:,1) ~fixed(:,2)],2)); % Fixed on X only
    plot(NODE(SUPP(ind,1),1),NODE(SUPP(ind,1),2),'r>','MarkerSize',6);
    ind = find(all([~fixed(:,1) fixed(:,2)],2)); % Fixed on Y only
    plot(NODE(SUPP(ind,1),1),NODE(SUPP(ind,1),2),'r^','MarkerSize',6);
    ind = find(all(fixed,2)); % Fixed on X and Y
    plot(NODE(SUPP(ind,1),1),NODE(SUPP(ind,1),2),'rx','MarkerSize',7,...
         'LineWidth',1.5);
end
if (nargin==4 && ~isempty(LOAD))
    loaded = LOAD(:,2:3)~=0;
    ind = find(all([loaded(:,1) ~loaded(:,2)],2)); % Loaded on X only
    plot(NODE(LOAD(ind,1),1),NODE(LOAD(ind,1),2),'b>','MarkerSize',6,...
         'MarkerFaceColor','b');
    ind = find(all([~loaded(:,1) loaded(:,2)],2)); % Loaded on Y only
    plot(NODE(LOAD(ind,1),1),NODE(LOAD(ind,1),2),'b^','MarkerSize',6,...
         'MarkerFaceColor','b');
    ind = find(all(loaded,2)); % Loaded on X and Y
    plot(NODE(LOAD(ind,1),1),NODE(LOAD(ind,1),2),'b+','MarkerSize',7,...
         'LineWidth',1.5);
end
axis('tight'), drawnow
return