function [x] = TubeDomain(Demand,Arg)
  BdBox = [0 2.5 -1.5 1.5];
  switch(Demand)
    case('Dist');  x = DistFnc(Arg,BdBox);
    case('BC');    x = BndryCnds(Arg{:},BdBox);
    case('BdBox'); x = BdBox;
    case('PFix');  x = FixedPoints(BdBox);
  end
%----------------------------------------------- COMPUTE DISTANCE FUNCTIONS
function Dist = DistFnc(P,BdBox)
  d1 = dRectangle(P,0,1,-1.5,1.5);
  d2 = dRectangle(P,0,1,-0.5,0.5);
  d3 = dCircle(P,1,0,1.5);
  d4 = dLine(P,1,1.5,1,-1.5);
  dleft = dDiff(d1,d2);
  dright= dIntersect(d3,d4);
  Dist = dUnion(dleft,dright);
%---------------------------------------------- SPECIFY BOUNDARY CONDITIONS
function [x] = BndryCnds(Node,Element,BdBox)
  eps = 0.1*sqrt((BdBox(2)-BdBox(1))*(BdBox(4)-BdBox(3))/size(Node,1));
  
  % Load point at [0 -1]
  aux = (Node(:,1)-0.0).^2 + (Node(:,2)-(-1.0)).^2;
  [~,ind] = sort(aux);
  Load = [ind(1) 1 0];
  
  % Restrain X in top left, and pin at [1 0]
  TopLeft = find(Node(:,1)<eps & Node(:,2)>0);
  aux = (Node(:,1)-1.0).^2 + (Node(:,2)-0.0).^2;
  [~,ind] = sort(aux);
  Supp = [ TopLeft ones(length(TopLeft),1) nan(length(TopLeft),1) ;
           ind(1) 1 1 ];
  
  x = {Supp,Load};
%----------------------------------------------------- SPECIFY FIXED POINTS
function [PFix] = FixedPoints(BdBox)
  PFix = [1  0;
          0 -1];
%-------------------------------------------------------------------------%