%------------------------------ PolyMesher -------------------------------%
% Tomas Zegard - 2014
%-------------------------------------------------------------------------%
function d = dPolygon(P,xp,yp)
% The polygon is assumed to be convex and numbered counter-clockwise
p_old = [xp(end) yp(end)];
d = zeros(size(P,1),length(xp));
for i=1:length(xp)
    p_new = [xp(i) yp(i)];
    d(:,i) = dLineLite(P,p_old(1),p_old(2),p_new(1),p_new(2));
    p_old = p_new;
end
d = [d,max(d,[],2)];
return

function d = dLineLite(P,x1,y1,x2,y2)
% By convention, a point located at the left hand side of the line
% is inside the region and it is assigned a negative distance value.
a = [x2-x1,y2-y1]; a = a/norm(a);
b = [P(:,1)-x1,P(:,2)-y1];
d = b(:,1)*a(2) - b(:,2)*a(1);
return
%-------------------------------------------------------------------------%