function [S, fval, exitflag] = ...
    DLOClassicOptimization(B, B0, N, I, fD, fL, fL0, g, Uw)

% ---- Assembly------------------------------------------------------------
Nb = size(B, 2)/2;
Np = size(N, 2);
Nf = size(B, 1) + Np + 1;
F = zeros(Nf,1);
F(end,1) = 1.;
BB= [B B0; -I N; (fL)' fL0'];
LL = [-fD-Uw; g];

% ---- Lower bound --------------------------------------------------------
lb = zeros(Nb * 2 + Np,1);
lb(1:Nb*2,1) = -inf;

% ---- Optimization -------------------------------------------------------
[S, fval, exitflag] = linprog(LL, [], [], BB, F, lb, []);

return