function [S, fval, exitflag, SF] = ...
    DLOCriticalSFFinder(B, B0, N, I, fD, fL, g, Uw, SFl, SFu, Nmax, eps)

% ---- Assembly------------------------------------------------------------
NL = N(1:2:size(N, 1),:);
Is = I(1:2:size(N, 1),:);
NQ = N(2:2:size(N, 1),:);
In = I(2:2:size(N, 1),:);
f = fD + fL + Uw;
maxfg = max(norm(g), norm(f));
g = g/maxfg;
f = f/maxfg;
Nb = size(B, 2)/2;
Np = size(N, 2);
Nf = size(B, 1) + Np;
F = zeros(Nf, 1);

% ---- Lower bound --------------------------------------------------------
lb = zeros(Nb * 2 + Np, 1);
lb(1:Nb*2, 1) = -1;
ub = zeros(Nb * 2 + Np, 1);
ub(:) = inf;
ub(1:Nb*2, 1) = 1;

% ---- Optimization -------------------------------------------------------
for i=1:Nmax
    fprintf('Iter = %i\n',i);
    SFmid = (SFl + SFu)/2;
    Psi = 1/SFmid;
    BB = [B B0; -Is NL; -In Psi*NQ]; LL = [(-f); g*Psi];
    [S, fval, exitflag] = linprog(LL, [], [], BB, F, lb, ub);
    if 0 > fval && fval >= -eps
        break 
    elseif fval+eps >0
        SFl = SFmid;
    elseif fval +eps <0
        SFu = SFmid;
    end
end 
SF = SFmid;

return