function [S, fval, exitflag] = ...
    DLOSFOptimization(B, B0, N, I, fD, fL, g, Uw)

% ---- Assembly------------------------------------------------------------
f = fD + fL + Uw;
maxfg = max(norm(g),norm(f));
g = g/maxfg;
f = f/maxfg;
Nb = size(B, 2)/2;
Np = size(N, 2);
Nf = size(B, 1) + Np;
F = zeros(Nf,1);
BB = [B B0; -I N]; 
LL = [-f;g];

% ---- Lower bound --------------------------------------------------------
lb = zeros(Nb * 2 + Np,1);
lb(1:Nb*2,1) = -1;
ub = zeros(Nb * 2 + Np,1);
ub(:) = inf;
ub(1:Nb*2,1) = 1;

% ---- Optimization -------------------------------------------------------
[S, fval, exitflag] = linprog(LL,[],[],BB,F,lb,ub);

return