function [NODE,ELEM,SUPP,LOAD,HYDH,EMAT] = BearingCapacityDomain(RefineLvl)

if (nargin<1)
    RefineLvl = 2; 
end

% Nodes
NODE = [-20  0; 
        -5  0;
        5  0; 
        20  0;
        -20  10; 
        -5  10;
         5  10; 
        20  10];

% Elements
ELEM = cell(1,3);
ELEM{1} = [1 2 6 5];
ELEM{2} = [2 3 7 6];
ELEM{3} = [3 4 8 7];
EMAT = ones(3,1);

% Refinement
[NODE,ELEM,EMAT] = MeshRefine(NODE,ELEM,EMAT,RefineLvl);

% Tolerence
Nn = size(NODE,1);
dx = max(NODE) - min(NODE);
tol = 1e-8 * sqrt(dx(1)*dx(2)) / Nn;

% Supports
SUPP = find(abs(NODE(:,1)-min(NODE(:,1)))<tol | ...
            abs(NODE(:,1)-max(NODE(:,1)))<tol | ...
            abs(NODE(:,2)-min(NODE(:,2)))<tol );
        
% Loads
loadNODE = find(abs(NODE(:,2)-max(NODE(:,2)))<tol & ...
                NODE(:,1) <= 5  & NODE(:,1) >=-5 );
LOAD = [loadNODE repmat([0 -102.83],length(loadNODE),1)];

% Hydraulic heads
HYDH = [];
return