function [NODE,ELEM,SUPP,LOAD,HYDH,EMAT] = LayeredSlopeDomain(RefineLvl)

if (nargin<1)
    RefineLvl = 2; 
end

% Nodes
NODE = [ 0  0; 
        10  0;
        20  0; 
        32  0;
        41  0; 
        50  0;
         0  5; 
        10  5;
        20  7; 
        32  4;
        41  4; 
        50  4;
        19  9.5; 
        30  9;
        34 11; 
        42 11;
        50 11; 
        30 15;
        40 15; 
        50 15;
        26 13];

% Elements
ELEM = cell(1,14);

ELEM{1} = [1 2 8 7];
ELEM{2} = [2 3 9 8];
ELEM{3} = [3 4 10 9];
ELEM{4} = [4 5 11 10];
ELEM{5} = [5 6 12 11];

ELEM{6} = [9 10 14];
ELEM{7} = [10 15 14];
ELEM{8} = [10 11 16 15];
ELEM{9} = [11 12 17 16];

ELEM{10} = [8 9 13];
ELEM{11} = [9 14 21 13];
ELEM{12} = [14 15 18 21];
ELEM{13} = [15 16 19 18];
ELEM{14} = [16 17 20 19];

EMAT = [3*ones(5,1); 2*ones(4,1); 1*ones(5,1)];

% Refinement
[NODE,ELEM,EMAT] = MeshRefine(NODE,ELEM,EMAT,RefineLvl);

% Tolerence
Nn = size(NODE,1);
dx = max(NODE) - min(NODE);
tol = 1e-8 * sqrt(dx(1)*dx(2)) / Nn;

% Supports
SUPP = find(abs(NODE(:,1)-min(NODE(:,1)))<tol | ...
            abs(NODE(:,1)-max(NODE(:,1)))<tol | ...
            abs(NODE(:,2)-min(NODE(:,2)))<tol );
% Loads
loadNODE = [];
LOAD = [loadNODE repmat([0 -1],length(loadNODE),1)];

% Hydraulic heads
HYDH=[];
return