function [NODEout,ELEMout,EMATout] = MeshRefine(NODE,ELEM,EMAT,RefineLvl)

NpE = cellfun(@length,ELEM,'UniformOutput',true);
Ni = RefineLvl + 2; % Nodes per edge after insertion

% Generate local coordinates for nodal insertion
[Txi,Teta,Qxi,Qeta] = GetLocalPartitionCoords(RefineLvl);

% Generate refinement patterns for tria and quad
k = 0;
INSERTtria = zeros(3,0);
for j=1:Ni-1
    left = (1:(Ni+1-j)) + k;
    right = (1:(Ni-j)) + left(end);
    k = left(end);
    INSERTtria = horzcat(INSERTtria,[left(1:end-1); right; left(2:end)],...
        [left(2:end-1); right(1:end-1); right(2:end)]);
end
INSERTquad = zeros(4,(Ni-1)^2);
for j=1:Ni-1
    n1 = (j-1)*Ni + 1;
    n2 = n1 + Ni;
    INSERTquad(:,(j-1)*(Ni-1)+(1:Ni-1)) = [n1+(0:Ni-2); n2+(0:Ni-2); n2+(1:Ni-1); n1+(1:Ni-1)];
end
INSERTtria = INSERTtria';
INSERTquad = INSERTquad';
    
ELEMtria = zeros(0,3);
ELEMquad = zeros(0,4);
EMATtria = zeros(0,1);
EMATquad = zeros(0,1);
NODEout = NODE;
% k = 0;
for i=1:length(ELEM)
    if (NpE(i)==3) % Triangle
        XY = NODE(ELEM{i},:);
        myNODE = nan(length(Txi),2);
        for j=1:length(Txi)
            N = ShapeFuncT3_embedded(Txi(j),Teta(j));
            myNODE(j,:) = N * XY;
        end
        ELEMtria = vertcat(ELEMtria,INSERTtria+size(NODEout,1));
        EMATtria = vertcat(EMATtria,repmat(EMAT(i),size(INSERTtria,1),1));
        NODEout = vertcat(NODEout,myNODE);
    elseif (NpE(i)==4) % Quadrangle
        XY = NODE(ELEM{i},:);
        myNODE = nan(length(Qxi),2);
        for j=1:length(Qxi)
            N = ShapeFuncQ4_embedded(Qxi(j),Qeta(j));
            myNODE(j,:) = N * XY;
        end
        ELEMquad = vertcat(ELEMquad,INSERTquad+size(NODEout,1));
        EMATquad = vertcat(EMATquad,repmat(EMAT(i),size(INSERTquad,1),1));
        NODEout = vertcat(NODEout,myNODE);
    elseif (NpE(i)>4)
        % ToDo: future development.
        error('Polygons are not yet supported.')
    else
        error('Element with fewer than 3 nodes.')
    end
end

ELEMout = cell(1,size(ELEMtria,1)+size(ELEMquad,1));
for i=1:size(ELEMtria,1)
    ELEMout{i} = ELEMtria(i,:);
end
for i=1:size(ELEMquad,1)
    ELEMout{i+size(ELEMtria,1)} = ELEMquad(i,:);
end
EMATout = vertcat(EMATtria,EMATquad);
[NODEout,ELEMout] = equivnode(NODEout,ELEMout);
return


function [N] = ShapeFuncQ4_embedded(xi,eta)
% N = zeros(1,4);
N = 1/4 * [(1-xi)*(1-eta) (1+xi)*(1-eta) (1+xi)*(1+eta) (1-xi)*(1+eta)];
return

function [N] = ShapeFuncT3_embedded(xi,eta)
% N=zeros(1,3);
N = [1-xi-eta xi eta];
return

function [Txi,Teta,Qxi,Qeta] = GetLocalPartitionCoords(RefineLvl)
xi_space = linspace(0,1,2+RefineLvl);
Txi = nan((2+RefineLvl)*(1+RefineLvl)/2,1);
Teta = Txi;
k = 0;
for i=length(xi_space):-1:1
    Txi(k+(1:i)) = xi_space(1:i);
    Teta(k+(1:i)) = xi_space(3+RefineLvl-i);
    k = k + i;
end
[Qxi,Qeta] = meshgrid(linspace(-1,1,2+RefineLvl),linspace(-1,1,2+RefineLvl));
Qxi = Qxi(:);
Qeta = Qeta(:);
return