function [NODE, ELEM, SUPP, LOAD, HYDH, EMAT] = ...
    MultiMaterialGroundWaterDomain(RefineLvl)

if (nargin<1)
    RefineLvl = 2; % Default element refinement
end

% Nodes
NODE = [  0  0;
         10  0;
         35  0;
         60  0 ;
         80  0;
          0  5;
         10  7;
         35  7;
         60  7;
         80  7;
         35 11;
         60 15;
         80 15;
         15 14;
         35 17;
         60 20;
         65 20;
         80 20;
         30 25;
         38 25;
         60 25;
        -10  0 ; 
        -10  5];
         
% Elements
ELEM = cell(1,15);
ELEM{1} = [1 2 7 6];
ELEM{2} = [2 3 8 7];
ELEM{3} = [3 4 9 8];
ELEM{4} = [4 5 10 9];
ELEM{5} = [7 8 11];
ELEM{6} = [8 9 12 11];
ELEM{7} = [9 10 13 12];
ELEM{8} = [7 11 15 14];
ELEM{9} = [11 12 16 15];
ELEM{10} = [12 17 16];
ELEM{11} = [12 13 18 17];
ELEM{12} = [14 15 20 19];
ELEM{13} = [15 16 21 20];
ELEM{14} = [16 17 21];
ELEM{15} = [22 1 6 23];
EMAT = [ones(7,1); 2*ones(4,1); 3*ones(3,1); 1];

% Refinement
[NODE, ELEM, EMAT] = MeshRefine(NODE, ELEM, EMAT, RefineLvl);

% Tolerence
Nn = size(NODE,1);
dx = max(NODE) - min(NODE);
tol = 1e-8 * sqrt(dx(1)*dx(2)) / Nn;

% Supports
SUPP = find(abs(NODE(:,1)-min(NODE(:,1)))<tol | ...
            abs(NODE(:,1)-max(NODE(:,1)))<tol | ...
            abs(NODE(:,2)-min(NODE(:,2)))<tol );

% Loads
loadNODE = find(abs(NODE(:,2)-max(NODE(:,2))) < tol & ...
                NODE(:,1) <= 38);
LOAD = [loadNODE repmat([0 -1], length(loadNODE),1)];

% Hydraulic heads
hNODE1 = find(abs(NODE(:,2) - 5 - (2/10) * NODE(:,1)) < tol & ...
              NODE(:,2) <= 10  & NODE(:,2) >= 5);
hNODE2 = find(abs(NODE(:,2) - 7 - (7/5) * (NODE(:,1) - 10)) < tol & ...
              NODE(:,2) <= 10 & NODE(:,2) > 7 );
hNODE3 = find(abs(NODE(:,2) - 20 ) < tol & NODE(:,1) >= 65 );
hNODE4 = find(abs(NODE(:,2) - 25 + (1) * (NODE(:,1) - 60)) < tol & ...
              NODE(:,2) <= 23 & NODE(:,2) > 20 );
hNODE5 = find(abs(NODE(:,2) - 5 ) < tol & NODE(:,1) < 0 );
HYDH = [hNODE1 repmat([10.],length(hNODE1),1);
        hNODE2 repmat([10.],length(hNODE2),1);
        hNODE3 repmat([23.],length(hNODE3),1);
        hNODE4 repmat([23.],length(hNODE4),1);
        hNODE5 repmat([10.],length(hNODE5),1)];

return