function [] = PlotMeshGeo(NODE,ELEM,SUPP,LOAD,HYDH,EMAT)
narginchk(2,6)

if (nargin>=6 && ~isempty(EMAT))
    EMAT = round(EMAT);
    if any(EMAT<1), error('Materials must be integers 1,2,3...'), end
    if isrow(EMAT), EMAT = EMAT'; end
    Nmat = max(EMAT);
else
    EMAT = ones(1,length(ELEM));
    Nmat = 1;
end

figure('Color','w'), hold on, axis equal, axis off
MaxNVer = max(cellfun(@numel,ELEM));         % Max vertices/element in mesh
PadWNaN = @(E) [E(:)' NaN(1,MaxNVer-numel(E))];  % Pad cells with NaN
ElemMat = cellfun(PadWNaN,ELEM,'UniformOutput',false);
ElemMat = vertcat(ElemMat{:});               % Create padded element matrix

palette = flipud(hsv(Nmat));
patch('Faces',ElemMat,'Vertices',NODE,'FaceVertexCData',palette(EMAT,:),...
    'FaceColor','flat','FaceAlpha',0.20);
plot(NODE(:,1),NODE(:,2),'k.')
if (nargin>=3 && ~isempty(SUPP))
    fixed = unique(SUPP);
    plot(NODE(fixed,1),NODE(fixed,2),'kx','MarkerSize',7,'LineWidth',1.5);
end
if (nargin>=4 && ~isempty(LOAD))
    loaded = (LOAD(:,2:3)~=0 & ~isnan(LOAD(:,2:3)));
    ind = find(all([loaded(:,1) ~loaded(:,2)],2)); % Loaded on X only
    plot(NODE(LOAD(ind,1),1),NODE(LOAD(ind,1),2),'r>','MarkerSize',6,...
         'MarkerFaceColor','r');
    ind = find(all([~loaded(:,1) loaded(:,2)],2)); % Loaded on Y only
    plot(NODE(LOAD(ind,1),1),NODE(LOAD(ind,1),2),'r^','MarkerSize',6,...
         'MarkerFaceColor','r');
    ind = find(all(loaded,2)); % Loaded on X and Y
    plot(NODE(LOAD(ind,1),1),NODE(LOAD(ind,1),2),'r+','MarkerSize',7,...
         'LineWidth',1.5);
end
if (nargin>=5 && ~isempty(HYDH))
    h = (HYDH(:,2)~=0 & ~isnan(HYDH(:,2)));
    ind = find(all(h,2)); 
    plot(NODE(HYDH(ind,1),1),NODE(HYDH(ind,1),2),'b+','MarkerSize',7,...
         'LineWidth',1.5);
end 
if (Nmat>1)
    colormap(palette)
    colorbar('Ticks',1:Nmat)
    clim([1 Nmat]+0.5*[-1 1])
end
axis('tight'), drawnow
return