function []= PlotMeshPressure(NODE,ELEM,uw,A,B)

figure('Color','w')
title('Nodal Pore Pressure')
hold on, axis equal, axis off
colormap(plasma)
colorbar
MaxNVer = max(cellfun(@numel,ELEM));         
PadWNaN = @(E) [E(:)' NaN(1,MaxNVer-numel(E))];  
ElemMat = cellfun(PadWNaN,ELEM,'UniformOutput',false);
ElemMat = vertcat(ElemMat{:});
patch('Vertices',NODE,'Faces',ElemMat,'FaceColor','flat','FaceVertexCData',uw)
plot([A(:,1) B(:,1)]',[A(:,2) B(:,2)]','g','LineWidth',2)
axis('tight')