function map = spectral(m)
%SPECTRAL Purple-blue-green-yellow-orange-red
%   SPECTRAL(M) returns an M-by-3 matrix containing a colormap. 
%   The colors begin with purple and blue, range through green, yellow,
%   and orange, and end with red. SPECTRAL is based on Cindy Brewer's
%   "colorbrewer" palettes. This function is equivalent to BREWER_D09.
%
%   SPECTRAL returns a colormap with the same number of colors as the current
%   figure's colormap. If no figure exists, MATLAB uses the length of the
%   default colormap.
%
%   EXAMPLE
%
%   This example shows how to reset the colormap of the current figure.
%
%       colormap(spectral)
%
%   See also BREWER_D01, BREWER_D02, BREWER_D03, BREWER_D04, BREWER_D05,
%   BREWER_D06, BREWER_D07, BREWER_D08, BREWER_D09, COLORMAP, RGBPLOT.

%   Copyright 2016 Tomas Zegard
%   $Revision: 1.0.0.0 $  $Date: 2016/12/29 12:41:20 $

if nargin < 1
   f = get(groot,'CurrentFigure');
   if isempty(f)
      m = size(get(groot,'DefaultFigureColormap'),1);
   else
      m = size(f.Colormap,1);
   end
end

values = [
0.368627, 0.309804, 0.635294
0.196078, 0.533333, 0.741176
0.400000, 0.760784, 0.647059
0.670588, 0.866667, 0.643137
0.901961, 0.960784, 0.596078
1.000000, 1.000000, 0.749020
0.996078, 0.878431, 0.545098
0.992157, 0.682353, 0.380392
0.956863, 0.427451, 0.262745
0.835294, 0.243137, 0.309804
0.619608, 0.003922, 0.258824
   ];

P = size(values,1);
map = interp1(1:size(values,1), values, linspace(1,P,m), 'linear');
return